package com.elitesland.fin.application.facade.base;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.base
 * @date 2023/2/16 09:21
 */
@Data
public class BaseWorkflowModelVO extends BaseModelVO {

    @ApiModelProperty("工作流-流程实例ID")
    private String procInstId;

    @ApiModelProperty("工作流-流程实例状态")
    private ProcInstStatus procInstStatus;

    /**
     * 时间相关
     */
    @ApiModelProperty(value = "工作流-提交时间")
    private LocalDateTime workflowSubmitTime;

    @ApiModelProperty(value = "工作流-审批通过时间")
    private LocalDateTime workflowEndTime;

    /**
     * 当前节点节点
     */
    @ApiModelProperty(value = "工作流-当前审批节点KEY")
    private String workflowCurrentNodeKey;

    @ApiModelProperty(value = "工作流-当前审批节点名称")
    private String workflowCurrentNodeName;

    @ApiModelProperty(value = "工作流-当前节点审批人用户ID（多个使用逗号分隔）")
    private String workflowCurrentUserIds;

    /**
     * 驳回相关
     */
    @ApiModelProperty(value = "工作流-审批驳回原因")
    private String workflowRejectedMessage;
}
