package com.elitesland.fin.application.facade.param.account;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户表")
public class AccountPageParam extends AbstractOrderQueryParam{

    private List<Long> ids;

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

//    @ApiModelProperty("归属加盟商编码")
//    private String secFranchiseeCode;

    @ApiModelProperty("开户主体类型")
    private String accountHolderType;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
    @ApiModelProperty("开户主体名称集合")
    private List<String> accountHolderNameList;
    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;
    @ApiModelProperty("开户主体编码集合")
    private List<String> accountHolderCodeList;
    @ApiModelProperty("开户主体名称编码")
    private String accountHolderNameCode;

    @ApiModelProperty("账户编码")
    private String accountCode;
    @ApiModelProperty("账户编码集合")
    private List<String> accountCodeList;
    @ApiModelProperty("账户名称")
    private String accountName;
    @ApiModelProperty("账户名称集合")
    private List<String> accountNameList;
    @ApiModelProperty("账户类型")
    private String accountType;
    @ApiModelProperty("账户类型集合")
    private List<String> accountTypeList;

    @ApiModelProperty("账户性质")
    private String accountNature;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("默认账户")
    private boolean defaultAccount;


}
