package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎数据行")
public class FinAccEngDetDataParam extends BaseModelParam {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("行名称")
    private String name;

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("行说明")
    private String description;

    @ApiModelProperty("借贷方 D/C")
    private String debitCredit;

    @ApiModelProperty("是否合并")
    private Boolean combineFlag;

    @ApiModelProperty("主机")
    private String journalHost;

    @ApiModelProperty("端口")
    private String journalPort;

    @ApiModelProperty("用户名")
    private String journalUser;

    @ApiModelProperty("密码")
    private String journalPassword;

    @ApiModelProperty("数据库名称")
    private String journalDatabase;

    @ApiModelProperty("主表")
    private String journalTable;

    private List<FinAccEngDetDataLineParam> FinAccEngDetDataLineList;
}
