package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎")
public class FinAccountEngineVO extends BaseModelVO {

    @ApiModelProperty("事件表单名称")
    private String eventTable;

    @ApiModelProperty("事件表单ID")
    private Long eventTableId;

    @ApiModelProperty("单据编码字段")
    private String columnDocNum;

    @ApiModelProperty("公司字段")
    private String columnCompany;

    @ApiModelProperty("主机")
    private String journalHost;

    @ApiModelProperty("端口")
    private String journalPort;

    @ApiModelProperty("用户名")
    private String journalUser;

    @ApiModelProperty("密码")
    private String journalPassword;

    @ApiModelProperty("数据库名称")
    private String journalDatabase;

    @ApiModelProperty("主表")
    private String journalTable;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("会计引擎明细")
    private List<FinAccountEngineDetailsVO> finAccountEngineDetails;
}
