package com.elitesland.fin.application.service.adjusttoorder;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.adjusttoorder.AdjustToOrderConvert;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.unionpay.entity.enums.SourceTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.StoredOrderTypeEnum;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 17:17
 */
@Service
@RequiredArgsConstructor
public class AdjustToOrderServiceImpl implements AdjustToOrderService {

    private final AdjustToOrderRepo adjustToOrderRepo;

    private final AdjustToOrderRepoProc adjustToOrderRepoProc;

    private final AccountRepoProc accountRepoProc;

    private final SysNumberGenerator sysNumberGenerator;

    private final AccountFlowService accountFlowService;

    private final CreditAccountFlowService creditAccountFlowService;

    private final AccountRepo accountRepo;


    @SysCodeProc
    @Override
    public PagingVO<AdjustToOrderVO> page(AdjustToOrderParam adjustOrderPageParam) {
        return AdjustToOrderConvert.INSTANCE.DTO2VO(adjustToOrderRepoProc.page(adjustOrderPageParam));
    }

    @SysCodeProc
    @Override
    public AdjustToOrderVO getOne(Long id) {
        return adjustToOrderRepoProc.queryById(id);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long approve(Long id) {
        AdjustToOrderDO adjustToOrderDO = adjustToOrderRepoProc.findById(id);

        Assert.equals(UdcEnum.APPLY_STATUS_DOING.getValueCode(), adjustToOrderDO.getDocState(), "只有审批中状态单据才可审批!");

        buildAdjustToOrderDO(adjustToOrderDO, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());

        //生成账户流水
        generateAccountFlow(adjustToOrderDO);

        //生成信用账户流水
        generateCreditAccountFlow(adjustToOrderDO);
        return id;
    }

    private void buildAdjustToOrderDO(AdjustToOrderDO adjustToOrderDO, String state) {
        SysUserDTO user = getUser();
        adjustToOrderDO.setDocState(state);
        adjustToOrderDO.setAuditTime(LocalDateTime.now());
        adjustToOrderDO.setAuditUser(user.getLastName());
        adjustToOrderDO.setAuditUserId(user.getId());
    }

    private void generateAccountFlow(AdjustToOrderDO adjustToOrderDO) {
        AccountFlowParam accountFlowParam = new AccountFlowParam();

        accountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_ATO.getValueCode());
        accountFlowParam.setSourceDocType(UdcEnum.ADJUST_TYPE_2.getValueCode());
        accountFlowParam.setSourceDocStatus(adjustToOrderDO.getDocState());
        accountFlowParam.setSourceDocAmount(adjustToOrderDO.getAdjustAmount());
        accountFlowParam.setSourceId(adjustToOrderDO.getId());
        accountFlowParam.setSourceNo(adjustToOrderDO.getDocNo());
        accountFlowParam.setAccountCode(adjustToOrderDO.getAccountCodeFrom());

        accountFlowService.generateAccountFlow(accountFlowParam);
    }

    private void generateCreditAccountFlow(AdjustToOrderDO adjustToOrderDO) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();

        creditAccountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_ATO.getValueCode());
        creditAccountFlowParam.setSourceDocType(UdcEnum.ADJUST_TYPE_1.getValueCode());
        creditAccountFlowParam.setSourceDocStatus(adjustToOrderDO.getDocState());
        creditAccountFlowParam.setSourceDocAmount(adjustToOrderDO.getAdjustAmount());
        creditAccountFlowParam.setSourceId(adjustToOrderDO.getId());
        creditAccountFlowParam.setSourceNo(adjustToOrderDO.getDocNo());
        creditAccountFlowParam.setCreditAccountCode(adjustToOrderDO.getAccountCodeTo());

        creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long reject(AdjustToOrderParam param) {
        Assert.notNull(param.getId(),"id必填");

        AdjustToOrderDO adjustToOrderDO = adjustToOrderRepoProc.findById(param.getId());

        Assert.equals(UdcEnum.APPLY_STATUS_DOING.getValueCode(), adjustToOrderDO.getDocState(), "只有审批中状态单据才可拒绝!");

        buildAdjustToOrderDO(adjustToOrderDO, UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode());
        if(StringUtils.isNotEmpty(param.getAuditRejectReason())){
            adjustToOrderDO.setAuditRejectReason(param.getAuditRejectReason());
        }

        //生成账户流水
        generateAccountFlow(adjustToOrderDO);

        return param.getId();
    }

    @Override
    public Long saveOrUpdate(AdjustToOrderParam adjustOrderParam) {
        checkSave(adjustOrderParam);
        if (adjustOrderParam.getId() == null) {
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
            AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
            adjustToOrderDO.setDocNo(docNo);
            adjustToOrderRepo.save(adjustToOrderDO);
            return adjustToOrderDO.getId();
        }

        AdjustToOrderDO adjustToOrderDO = adjustToOrderRepoProc.findById(adjustOrderParam.getId());
        checkAdjustToOrderState(adjustToOrderDO);

        AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam, adjustToOrderDO);
        adjustToOrderRepo.save(adjustToOrderDO);
        return adjustToOrderDO.getId();
    }

    private void checkAdjustToOrderState(AdjustToOrderDO adjustToOrderDO) {
        Assert.equals(adjustToOrderDO.getDocState(), UdcEnum.APPLY_STATUS_DRAFT.getValueCode(), "当前状态无法编辑");
    }

    @Override
    @Transactional
    public void submit(Long id) {

        AdjustToOrderDO adjustToOrderDO = adjustToOrderRepoProc.findById(id);

        adjustToOrderDO.setDocState(UdcEnum.APPLY_STATUS_DOING.getValueCode());

        generateAccountFlow(adjustToOrderDO);

        adjustToOrderRepo.save(adjustToOrderDO);
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        return userDetails.getUser();
    }

    private void checkSave(AdjustToOrderParam adjustToOrderParam) {
        Assert.notEmpty(adjustToOrderParam.getAdjustReason(), "调整原因不能为空!");
        Assert.notEmpty(adjustToOrderParam.getAccountNameFrom(), "从账户名称不能为空!");
        Assert.notEmpty(adjustToOrderParam.getAccountCodeFrom(), "从账户编码不能为空!");
        Assert.notEmpty(adjustToOrderParam.getAccountTypeFrom(), "从账户类型不能为空!");
        Assert.notEmpty(adjustToOrderParam.getAccountCodeTo(), "至账户编码不能为空!");
        Assert.notEmpty(adjustToOrderParam.getAccountTypeTo(), "至账户类型不能为空!");
        if (adjustToOrderParam.getAccountCodeFrom().equals(adjustToOrderParam.getAccountCodeTo())) {
            throw new BusinessException("从账户和至账户不能是同一个!");
        }
        if (adjustToOrderParam.getAdjustAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("调整金额不能小于或等于0");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        String transactionType = "";
        String dataSource = "";
        String transactionType2 = "";
        String dataSource2 = "";
        List<AccountFlowParam> param = new ArrayList<>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCodeFrom());
        accountFlowParam.setAccName(saveFlowParam.getAccNameFrom());
        accountFlowParam.setSplitType(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_FROM);
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccTypeFrom());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        AccountFlowParam accountFlowParam2 = new AccountFlowParam();
        accountFlowParam2.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam2.setAccCode(saveFlowParam.getAccCodeTo());
        accountFlowParam2.setAccName(saveFlowParam.getAccNameTo());
        accountFlowParam2.setSplitType(FinConstant.SPLIT_TYPE_ADJUST_APPROVE_TO);
        accountFlowParam2.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam2.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam2.setAccType(saveFlowParam.getAccTypeTo());
        accountFlowParam2.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam2.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        //整车
        if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.REJECT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //配件
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.REJECT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //附件包
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) &&
                saveFlowParam.getScene().equals(FinConstant.SUBMIT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) &&
                saveFlowParam.getScene().equals(FinConstant.REJECT)) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            //统筹
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) &&
                saveFlowParam.getScene().equals(FinConstant.APPROVED)) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        accountFlowParam2.setTransactionType(transactionType2);
        accountFlowParam2.setDataSource(dataSource2);
        if (!StringUtils.isEmpty(transactionType2) && !StringUtils.isEmpty(dataSource2)) {
            param.add(accountFlowParam2);
        }
        if (!StringUtils.isEmpty(transactionType) && !StringUtils.isEmpty(dataSource)) {
            param.add(accountFlowParam);
        }

        if (!CollectionUtils.isEmpty(param)) {
            accountFlowService.save(param);
        }
    }



}
