package com.elitesland.fin.application.service.excel.entity;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalConvert;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

@ApiModel(value = "信用账户快照返回值",description = "信用账户快照返回值")
@Data
public class CreditAccountSnapshotExportEntity implements Serializable {

    @ExcelProperty(value = "快照时间", index = 0)
    private LocalDateTime snapshotTime;

    @ExcelProperty(value = "授信组织", index = 1)
    private String ouName;

    @ExcelProperty(value = "对象名称", index = 2)
    private String objectName;

    @ExcelProperty(value = "对象编码", index = 3)
    private String objectCode;

    @ExcelProperty(value = "产品线名称", index = 4)
    private String productLineName;

    @ExcelProperty(value = "业务员姓名", index = 5)
    private String salesmanName;

    @ExcelProperty(value = "信用账户编码", index = 6)
    private String creditAccountCode;

    @ExcelProperty(value = "信用账户名称", index = 7)
    private String creditAccountName;

    @ExcelProperty(value = "信用账户类型", index = 8)
    private String creditAccountTypeName;

    @ExcelProperty(value = "信用账户额度", index = 9, converter = BigDecimalConvert.class)
    private BigDecimal creditAccountLimit;

    @ExcelProperty(value = "信用账户使用额度", index = 10, converter = BigDecimalConvert.class)
    private BigDecimal creditAccountUsedLimit;

    @ExcelProperty(value = "信用账户占用额度", index = 11, converter = BigDecimalConvert.class)
    private BigDecimal creditAccountOccupancyLimit;

    @ExcelProperty(value = "信用账户可用额度", index = 12, converter = BigDecimalConvert.class)
    private BigDecimal creditAccountAvailableLimit;

    @ExcelProperty(value = "状态", index = 13)
    private String statusName;


    public BigDecimal getCreditAccountAvailableLimit() {
        return format(creditAccountAvailableLimit);

    }

    public BigDecimal getCreditAccountLimit() {
        return format(creditAccountLimit);
    }

    public BigDecimal getCreditAccountOccupancyLimit() {
        return format(creditAccountOccupancyLimit);
    }

    public BigDecimal getCreditAccountUsedLimit() {
        return format(creditAccountUsedLimit);
    }

    public BigDecimal format(BigDecimal amount) {
        if (ObjectUtil.isNotNull(amount)) {
            return amount.setScale(2, RoundingMode.HALF_UP);
        }
        return amount;
    }

}
