package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.AccountSnapshotExportEntity;
import com.elitesland.fin.common.UdcEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class AccountSnapshotExportServiceImpl implements DataExport<AccountSnapshotExportEntity, AccountSnapshotParam> {

    private final AccountService accountService;

    @Override
    public String getTmplCode() {
        return "fin_account_snapshot_export";
    }

    public PagingVO<AccountSnapshotExportEntity> executeExport(AccountSnapshotParam queryParam) {

        PagingVO<AccountSnapshotVo> pagingVO = accountService.querySnapshot(queryParam);

        return AccountConvert.INSTANCE.pageVo2Entity(pagingVO);

    }
}
