package com.elitesland.fin.application.service.recorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.domain.param.recorder.RecOrderDetailSaveParam;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/6/16
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RecOrderRpcDetailServiceImpl implements RecOrderRpcDetailService {

    @Autowired
    private RecOrderDtlRepoProc recOrderDtlRepoProc;

    @SysCodeProc
    @Override
    public List<RecOrderDetailSaveParam> getDetail(Long id) {
        List<RecOrderDtlDTO> recOrderDtls = recOrderDtlRepoProc.queryByMasId(id);
        List<RecOrderDetailSaveParam> recOrderDetailSaveParamArrayList = Lists.newArrayList();
        recOrderDtls.forEach(a -> {
            RecOrderDetailSaveParam recOrderDetailSaveParam = new RecOrderDetailSaveParam();
            BeanUtils.copyProperties(a, recOrderDetailSaveParam);
            recOrderDetailSaveParamArrayList.add(recOrderDetailSaveParam);
        });
        return recOrderDetailSaveParamArrayList;
    }

}
