package com.elitesland.fin.application.web.adjusttoorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhiyu.he
 * @date 2023/3/3 17:13
 */
@RestController
@RequestMapping("/adjustTo")
@RequiredArgsConstructor
@Api(value = "调剂单", tags = {"调剂单"})
public class AdjustToOrderController {
    private final AdjustToOrderService adjustToOrderService;

    @PostMapping("/page")
    @ApiOperation("分页查询调剂单")
    public ApiResult<PagingVO<AdjustToOrderVO>> page(@RequestBody AdjustToOrderParam adjustOrderPageParam) {
        return ApiResult.ok(adjustToOrderService.page(adjustOrderPageParam));
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改调剂单")
    public ApiResult<Long> saveOrUpdate(@RequestBody AdjustToOrderParam adjustOrderParam) {
        return ApiResult.ok(adjustToOrderService.saveOrUpdate(adjustOrderParam));
    }

    @GetMapping("/submit/{id}")
    @ApiOperation("提交调剂单")
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        adjustToOrderService.submit(id);
        return ApiResult.ok();
    }


//    @GetMapping("/getOne/{id}")
//    @ApiOperation("调剂单详情")
//    public ApiResult<AdjustToOrderVO> getOne(@PathVariable("id") Long id) {
//        return ApiResult.ok(adjustToOrderService.getOne(id));
//    }

    @GetMapping("/approve/{id}")
    @ApiOperation("批量审批调剂单")
    public ApiResult<Long> approve(@PathVariable("id") Long id) {
        return ApiResult.ok(adjustToOrderService.approve(id));
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝调剂单")
    public ApiResult<Long> reject(@RequestBody AdjustToOrderParam param) {
        return ApiResult.ok(adjustToOrderService.reject(param));
    }
}
