package com.elitesland.fin.application.web.arverconfig;
import com.elitesland.fin.application.facade.param.arverconfig.ArVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigVO;
import com.elitesland.fin.application.facade.vo.arverconfig.RecAndArOrderVO;
import com.elitesland.fin.application.service.arverconfig.ArVerConfigService;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.domain.param.arverconfig.OrderParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 15:29
 */
@RestController
@RequestMapping("/fin/arVerConfig")
@RequiredArgsConstructor
@Api(value = "应收核销管理方案", tags = {"应收核销管理方案"})
public class ArVerConfigController {

    private final ArVerConfigService arVerConfigService;
    @PostMapping("order")
    @ApiOperation("根据查询条件查询收款单和应收单信息")
    public ApiResult<RecAndArOrderVO> queryOrderByParam(@RequestBody OrderParam param) {
        return ApiResult.ok(arVerConfigService.queryOrderByParam(param));
    }

    @PostMapping("save")
    @ApiOperation("新增/修改核销方案")
    public ApiResult<String> save(@RequestBody ArVerConfigSaveParam param) {
        return arVerConfigService.save(param);
    }

    @GetMapping("queryDetails/{id}")
    @ApiOperation("查看详情")
    public ApiResult<ArVerConfigVO> queryDetail(@PathVariable("id") Long id) {
        return arVerConfigService.queryById(id);
    }

    @GetMapping("queryDtl")
    @ApiOperation("获取配置字段")
    public ApiResult<List<ArVerConfigDtlVO>> queryDetail() {
        return arVerConfigService.queryDtl();
    }

    @GetMapping("queryAll")
    @ApiOperation("获取已启用的核销方案下拉框")
    public ApiResult<List<ArVerConfigVO>> queryAll() {
        return arVerConfigService.queryAllConfig();
    }

    @PostMapping("pageConfig")
    @ApiOperation("分页查询核销方案列表")
    public ApiResult<PagingVO<ArVerConfigVO>> pageConfig(@RequestBody ArVerConfigPageParam param) {
        return arVerConfigService.page(param);
    }

    @PutMapping("stop")
    @ApiOperation("停用核销方案")
    public ApiResult<List<Long>> stop(@RequestBody List<Long> ids) {
        return arVerConfigService.stop(ids);
    }

    @PutMapping("updateDef/{id}")
    @ApiOperation("设置默认")
    public ApiResult<Long> updateDef(@PathVariable("id") Long id) {
        return arVerConfigService.updateDef(id);
    }

    @GetMapping("getDef")
    @ApiOperation("获取核销方案默认")
    public ApiResult<ArVerConfigVO> getDef() {
        return arVerConfigService.getDef();
    }
}
