package com.elitesland.fin.application.web.limitadjustorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.facade.vo.limitadjustorder.LimitAdjustOrderVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:08
 */
@RestController
@RequestMapping("/limitAdjust")
@RequiredArgsConstructor
@Api(value = "额度调整单", tags = {"额度调整单"})
public class LimitAdjustOrderController {

    private final LimitAdjustOrderService limitAdjustOrderService;

    @PostMapping("/page")
    @ApiOperation("分页查询额度调整单")
    public ApiResult<PagingVO<LimitAdjustOrderVO>> page(@RequestBody LimitAdjustOrderParam limitAdjustOrderParam) {
        return ApiResult.ok(limitAdjustOrderService.page(limitAdjustOrderParam));
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改额度调整单")
    public ApiResult<Long> saveOrUpdate(@RequestBody LimitAdjustOrderParam limitAdjustOrderParam) {
        return ApiResult.ok(limitAdjustOrderService.saveOrUpdate(limitAdjustOrderParam));
    }

    @GetMapping("/submit/{id}")
    @ApiOperation("提交额度调整单")
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        limitAdjustOrderService.submit(id);
        return ApiResult.ok();
    }
}
