package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_journal_log")
@org.hibernate.annotations.Table(appliesTo = "fin_journal_log", comment = "凭证日志")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinJournalLogDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "doc_num", columnDefinition = "varchar(20) comment '单据编码'")
    private String docNum;

    @Column(name = "log", columnDefinition = "varchar(512) comment '日志'")
    private String log;
}
