package com.elitesland.fin.domain.entity.aporder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-3-16
 * @desc : 应付单明细
 */
@Entity
@Table(name="ap_order_dtl")
@org.hibernate.annotations.Table(appliesTo = "ap_order_dtl", comment = "应付单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApOrderDtlDO extends BaseModel implements Serializable {


    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(32) comment '商品名称'")
    private String itemName;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '规格型号'")
    private String itemType;

    @Column(name = "small_cate_code", columnDefinition = "varchar(32) comment '小类编码'")
    private String smallCateCode;

    @Column(name = "small_cate_name", columnDefinition = "varchar(32) comment '小类名称'")
    private String smallCateName;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(32) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "excl_tax_price", columnDefinition = "decimal(18,8) comment '单价'")
    private BigDecimal exclTaxPrice;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;







    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApOrderDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApOrderDtlDO entity = (ApOrderDtlDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}