package com.elitesland.fin.domain.service.aporder;

import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aporder
 * @date 2022/3/17 11:56
 */
@Service
@RequiredArgsConstructor
public class ApOrderDtlDomainServiceImpl implements ApOrderDtlDomainService {

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;

    @Override
    public PagingVO<ApOrderDtlDTO> page(ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlDTO> res = apOrderDtlRepoProc.page(apOrderDtlPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {
        Long res = apOrderDtlRepoProc.del(ids);
        return res;
    }

}
