package com.elitesland.fin.domain.service.saleinv;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.saleinv
 * @date 2022/5/7 13:29
 */
@Service
@RequiredArgsConstructor
public class SaleInvDtlDomainServiceImp implements SaleInvDtlDomainService {

    public final SaleInvDtlRepoProc saleInvDtlRepoProc;


    @Override
    public List<SaleInvDtlDTO> getList(Long masId) {
        List<SaleInvDtlDTO> list = saleInvDtlRepoProc.getList(masId);
        return list;
    }


    @Override
    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = saleInvDtlRepoProc.dtlPage(saleInvDtlPageParam);
        return res;
    }

    @Override
    public List<SaleInvDtlVO> getSummaryList(List<SaleInvDtlParam> saleInvDtlParamList) {

        Map<String, List<SaleInvDtlParam>> collect = saleInvDtlParamList.stream().collect(Collectors.groupingBy(item->item.getItemCode().concat(item.getTaxRate().toString())));
        List<SaleInvDtlVO> result = new ArrayList<>();
        collect.forEach((itemCode, details) -> {
            SaleInvDtlParam row = details.get(0);
            SaleInvDtlVO curr = new SaleInvDtlVO();

            curr.setId(row.getId());
            curr.setInvNature(row.getInvNature());
            curr.setInvNatureName(row.getInvNatureName());
            curr.setItemId(row.getItemId());
            curr.setItemCode(row.getItemCode());
            curr.setItemName(row.getItemName());
            curr.setTaxCode(row.getTaxCode());
            curr.setTaxName(row.getTaxName());
            curr.setItemType(row.getItemType());
            curr.setUom(row.getUom());
            curr.setUomName(row.getUomName());
            curr.setQty(add(details, SaleInvDtlParam::getQty));
            BigDecimal priceTotal = add(details, SaleInvDtlParam::getTotalAmt);
            curr.setPrice(priceTotal.divide(curr.getQty(), 2, RoundingMode.HALF_UP));
            curr.setTotalAmt(add(details, SaleInvDtlParam::getTotalAmt));
            curr.setTaxRate(row.getTaxRate());
            curr.setTaxAmt(add(details, SaleInvDtlParam::getTaxAmt));
            curr.setExclTaxAmt(add(details, SaleInvDtlParam::getExclTaxAmt));
            curr.setFlDeductionAmt(add(details, SaleInvDtlParam::getFlDeductionAmt));
            curr.setInvDiscountAmt(add(details, SaleInvDtlParam::getInvDiscountAmt));
            curr.setDiscountAmt(add(details, SaleInvDtlParam::getDiscountAmt));
            curr.setInvAmt(add(details, SaleInvDtlParam::getInvAmt));

            result.add(curr);
        });
        return result;
    }

    private BigDecimal add(List<SaleInvDtlParam> details, Function<SaleInvDtlParam, BigDecimal> func) {
        return details.stream().map(func).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}
