package com.elitesland.fin.entity.adjusttoorder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.Where;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author  zhiyu.he
 * @date  2023/3/3 15:01
 */


@Entity
@org.hibernate.annotations.Table(appliesTo = "adjust_order_to", comment = "调剂单")
@Table(name="adjust_order_to")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class AdjustToOrderDO extends BaseModel {

    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '调剂单号'")
    private String docNo;

    @Column(name = "doc_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String docState;

    @Column(name = "account_type_from", columnDefinition = "varchar(32) comment '从账户类型'")
    private String accountTypeFrom;

    @Column(name = "account_code_from", columnDefinition = "varchar(32) comment '从账户编码'")
    private String accountCodeFrom;

    @Column(name = "account_name_from", columnDefinition = "varchar(32) comment '从账户名称'")
    private String accountNameFrom;

    @Column(name = "account_name_to", columnDefinition = "varchar(32) comment '至账户名称'")
    private String accountNameTo;

    @Column(name = "account_type_to", columnDefinition = "varchar(32) comment '至账户类型'")
    private String accountTypeTo;

    @Column(name = "account_code_to", columnDefinition = "varchar(32) comment '至账户编码'")
    private String accountCodeTo;

    @Column(name = "adjust_reason", columnDefinition = "varchar(128) comment '调整原因'")
    private String adjustReason;

    @Column(name = "adjust_amount", columnDefinition = "decimal(18,8) comment '调整金额'")
    private BigDecimal adjustAmount;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_time", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditTime;

    @Column(name = "audit_reject_reason", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejectReason;
}
