package com.elitesland.fin.entity.creditaccount;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "credit_account_initial_limit")
@org.hibernate.annotations.Table(appliesTo = "credit_account_initial_limit", comment = "信用账户期初额度")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class CreditAccountInitialLimitDO extends BaseModel {


    @Column(name = "account_code", columnDefinition = "varchar(32) comment '信用账户编码'")
    private String creditAccountCode;

    @Column(name = "account_name", columnDefinition = "varchar(32) comment '信用账户名称'")
    private String creditAccountName;

    @Column(name = "initial_account_limit", columnDefinition = "decimal(18,8) comment '期初账户额度'")
    private BigDecimal initialAccountLimit;

    @Column(name = "initial_account_used_limit", columnDefinition = "decimal(18,8) comment '期初账户使用额度'")
    private BigDecimal initialAccountUsedLimit;

    @Column(name = "initial_account_occupancy_limit", columnDefinition = "decimal(18,8) comment '期初占用额度'")
    private BigDecimal initialAccountOccupancyLimit;

    @Column(name = "initial_account_available_limit", columnDefinition = "decimal(18,8) comment '期初可用额度'")
    private BigDecimal initialAccountAvailableLimit;

    @Column(name = "status", columnDefinition = "varchar(32) default 'DRAFT'  comment '状态'")
    private String status;

    @Comment("初始化结束时间")
    private LocalDateTime finishedTime;
}
