package com.elitesland.fin.infr.factory.arorder;

import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.factory.arorder
 * @date 2022/4/12 17:52
 */
@RequiredArgsConstructor
@Component
public class ArOrderFactory {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        PagingVO<ArOrderDTO> page = arOrderRepoProc.page(arOrderPageParam, masId);
        page.getRecords().forEach(x -> {
                    x.setTotalCount(arOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO,BigDecimal::add));
                    x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
                }
        );
        return page;
    }

}
