package com.elitesland.fin.infr.repo.invoiceredraft;

import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftQueryParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@Component
@RequiredArgsConstructor
public class InvoiceRedraftRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QBean<InvoiceRedraftPageVO> pageList = Projections.bean(
            InvoiceRedraftPageVO.class,
            qdo.id,
            qdo.origApplyNo,
            qdo.invoiceNo,
            qdo.serialNo,
            qdo.invoiceAmt,
            qdo.invoiceDate,
            qdo.invoiceType,
            qdo.invoiceDeduction,
            qdo.redraftReason,
            qdo.attachmentId,
            qdo.workflowProcInstStatus,
            qdo.workflowProcInstId,
            qdo.tenantId,
            qdo.remark,
            qdo.creator,
            qdo.createUserId,
            qdo.modifyUserId,
            qdo.createTime,
            qdo.modifyTime,
            qdo.deleteFlag,
            qdo.docStatus
    );

    public PagingVO<InvoiceRedraftPageVO> queryPaging(InvoiceRedraftQueryParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(qdo);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, qdo);
        jpaQuery.where(this.wherePage(paramVO));
        //查询
        return PagingVO.<InvoiceRedraftPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public void update(InvoiceRedraftDO invoiceRedraftDO) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.where(qdo.id.eq(invoiceRedraftDO.getId()));
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getOrigApplyNo())){
            update.set(qdo.origApplyNo,invoiceRedraftDO.getOrigApplyNo());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getInvoiceNo())){
            update.set(qdo.invoiceNo,invoiceRedraftDO.getInvoiceNo());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getInvoiceAmt())){
            update.set(qdo.invoiceAmt,invoiceRedraftDO.getInvoiceAmt());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getInvoiceDate())){
            update.set(qdo.invoiceDate,invoiceRedraftDO.getInvoiceDate());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getInvoiceType())){
            update.set(qdo.invoiceType,invoiceRedraftDO.getInvoiceType());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getInvoiceDeduction())){
            update.set(qdo.invoiceDeduction,invoiceRedraftDO.getInvoiceDeduction());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getRedraftReason())){
            update.set(qdo.redraftReason,invoiceRedraftDO.getRedraftReason());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getAttachmentId())){
            update.set(qdo.attachmentId,invoiceRedraftDO.getAttachmentId());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getWorkflowSubmitTime())){
            update.set(qdo.workflowSubmitTime,invoiceRedraftDO.getWorkflowSubmitTime());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getWorkflowProcInstId())){
            update.set(qdo.workflowProcInstId,invoiceRedraftDO.getWorkflowProcInstId());
        }
        if (!ObjectUtils.isEmpty(invoiceRedraftDO.getWorkflowProcInstStatus())){
            update.set(qdo.workflowProcInstStatus,invoiceRedraftDO.getWorkflowProcInstStatus());
        }
        update.execute();
    }

    private Predicate wherePage(InvoiceRedraftQueryParam query) {
        List<Predicate> predicates = new ArrayList<>();
        if (!ObjectUtils.isEmpty(query.getWorkflowProcInstStatus())) {
            predicates.add(qdo.workflowProcInstStatus.eq(query.getWorkflowProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getOrigApplyNo())) {
            predicates.add(qdo.origApplyNo.like(SqlUtil.toSqlLikeString(query.getOrigApplyNo())));
        }
        if (!ObjectUtils.isEmpty(query.getInvoiceNo())) {
            predicates.add(qdo.invoiceNo.like(SqlUtil.toSqlLikeString(query.getInvoiceNo())));
        }
        if (!ObjectUtils.isEmpty(query.getInvoiceType())) {
            predicates.add(qdo.invoiceType.eq(query.getInvoiceType()));
        }
        if (!ObjectUtils.isEmpty(query.getInvoiceDateStart()) && !ObjectUtils.isEmpty(query.getInvoiceDateEnd())) {
            predicates.add(qdo.invoiceDate.between(query.getInvoiceDateStart(),query.getInvoiceDateEnd()));
        }
        if (StringUtils.isNotEmpty(query.getInvoiceNo())) {
            predicates.add(qdo.invoiceNo.eq(query.getInvoiceNo()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InvoiceRedraftPageVO> queryByInvoiceNoCreateTimeDesc(InvoiceRedraftQueryParam invoiceRedraftQueryParam){

        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(qdo);
        jpaQuery.where(this.wherePage(invoiceRedraftQueryParam));
        jpaQuery.orderBy(qdo.createTime.desc());

        return jpaQuery.fetch();
    }

}
