package com.elitesland.fin.provider.payorder;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import com.elitesland.fin.service.payorder.PayOrderRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.payorder
 * @date 2022/5/18 13:16
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayOrderRpcService.PATH)
public class PayOrderRpcServiceImpl implements PayOrderRpcService {

    public final PayOrderDomainService payOrderDomainService;

    @Override
    public Long save(PayOrderRpcParam payOrderRpcParam) {
        if (CharSequenceUtil.isBlank(payOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertRpc(payOrderRpcParam);
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = payOrderDomainService.save(payOrder);
        return resId;
    }

    @Override
    public ApiResult<PagingVO<PayOrderRpcDTO>> page(PayOrderPageRpcParam payOrderPageRpcParam) {
        PayOrderPageParam payOrderPageParam = PayOrderConvert.INSTANCE.convertPageParamRpc(payOrderPageRpcParam);
        PagingVO<PayOrderRpcDTO> res = PayOrderConvert.INSTANCE.convertRpcDto(payOrderDomainService.page(payOrderPageParam));
        return ApiResult.ok(res);
    }
}
