package com.elitesland.fin.provider.saleinv;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.dto.saleinv.SaleInvRpcDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.param.saleinv.SaleInvRpcParam;
import com.elitesland.fin.service.payorder.PayOrderRpcService;
import com.elitesland.fin.service.saleinv.SaleInvRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.saleinv
 * @date 2022/5/23 14:08
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + SaleInvRpcService.PATH)
public class SaleInvRpcServiceImpl implements SaleInvRpcService {

    public final SaleInvDomainService saleInvDomainService;

    @Override
    public Long save(SaleInvRpcParam saleInvRpcParam) {
        if (CharSequenceUtil.isBlank(saleInvRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        SaleInv saleInv = SaleInvConvert.INSTANCE.convertRpc(saleInvRpcParam);
        saleInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = saleInvDomainService.save(saleInv);
        return resId;
    }

    @Override
    public ApiResult<SaleInvRpcDTO> querySaleInvById(Long id) {

        SaleInvDTO saleInvDTO = saleInvDomainService.get(id);
        return ApiResult.ok(SaleInvConvert.INSTANCE.saleInvDTO2SaleInvRpcDTO(saleInvDTO));
    }
}
