package com.elitesland.fin.repo.account;

import com.elitesland.fin.entity.account.AccountDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public interface AccountRepo extends JpaRepository<AccountDO, Long>, QuerydslPredicateExecutor<AccountDO> {

    AccountDO findByAccountCode(String accCode);

    List<AccountDO> findByAccountHolderName(String accountHolderName);

    List<AccountDO> findAllByAccountCode(String accountCode);

    boolean existsByAccountCode(String accountCode);

    boolean existsByAccountNameAndAccountType(String accountName, String accountType);

    boolean existsBySecOuCodeAndAccountHolderCodeAndAccountType(String secOuCode, String accountHolderCode, String accountType);
}
