package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFastCodeDO;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinFastCodeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeLineRepo finFastCodeLineRepo;

    private final QFinFastCodeDO qFinFastCodeDO = QFinFastCodeDO.finFastCodeDO;

    public PagingVO<FinFastCodeDTO> page(FinFastCodeParam finFastCodeParam) {
        Predicate where = where(finFastCodeParam);
        JPAQuery<FinFastCodeDTO> query = select(FinFastCodeDTO.class).where(ExpressionUtils.allOf(where));
        finFastCodeParam.setPaging(query);
        finFastCodeParam.fillOrders(query, qFinFastCodeDO);

        List<FinFastCodeDTO> finFastCodeDTOList = query.fetch();

        List<Long> ids = finFastCodeDTOList.stream().map(FinFastCodeDTO::getId).collect(Collectors.toList());
        List<FinFastCodeLineDTO> finFastCodeLineDTOList = FinFastCodeLineConvert.INSTANCE.DOToDTO(finFastCodeLineRepo.findAllByMasIdIn(ids));

        for (FinFastCodeDTO finFastCodeDTO : finFastCodeDTOList) {
            finFastCodeDTO.setFinFastCodeLineDetailList(finFastCodeLineDTOList.stream()
                    .filter(finFastCodeLineDTO -> finFastCodeDTO.getId().equals(finFastCodeLineDTO.getMasId()))
                    .collect(Collectors.toList()));
        }

        return PagingVO.<FinFastCodeDTO>builder()
                .total(finFastCodeDTOList.size())
                .records(finFastCodeDTOList)
                .build();
    }

    private Predicate where(FinFastCodeParam finFastCodeParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finFastCodeParam.getId() != null, qFinFastCodeDO.id, finFastCodeParam.getId())
                .andLike(StringUtils.isNotEmpty(finFastCodeParam.getFastCode()), qFinFastCodeDO.fastCode, StringUtil.buildLikeString(finFastCodeParam.getFastCode()))
                .andLike(StringUtils.isNotEmpty(finFastCodeParam.getFastName()), qFinFastCodeDO.fastName, StringUtil.buildLikeString(finFastCodeParam.getFastName()))
                .andEq(StringUtils.isNotEmpty(finFastCodeParam.getStatus()), qFinFastCodeDO.status, finFastCodeParam.getStatus())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinFastCodeDO.id,
                qFinFastCodeDO.fastCode,
                qFinFastCodeDO.fastName,
                qFinFastCodeDO.status,

                qFinFastCodeDO.createTime,
                qFinFastCodeDO.creator,
                qFinFastCodeDO.modifyTime,
                qFinFastCodeDO.updater
        )).from(qFinFastCodeDO);
    }


    public FinFastCodeDO findByFastCode(String finFastCode) {

        List<FinFastCodeDO> finFastCodeDOList = finFastCodeRepo.findAllByFastCode(finFastCode);

        if (CollectionUtils.isNotEmpty(finFastCodeDOList)) {
            Assert.equals(finFastCodeDOList.size(), 1, "查询到多条快码");
            return finFastCodeDOList.get(0);
        }
        return null;
    }

    public List<FinFastCodeDO> findAllByFastCodeIn(List<String> finFastCodeList) {

        if(CollectionUtils.isEmpty(finFastCodeList)){
            return Lists.newArrayList();
        }

        List<FinFastCodeDO> finFastCodeDOList = finFastCodeRepo.findAllByFastCodeIn(finFastCodeList);
        Assert.notEmpty(finFastCodeDOList,"查不到快码");

        return finFastCodeDOList;
    }

    public List<FinFastCodeDO> findAllByFastCodeInAndStatus(List<String> finFastCodeList,String status) {

        if(CollectionUtils.isEmpty(finFastCodeList)){
            return Lists.newArrayList();
        }

        List<FinFastCodeDO> finFastCodeDOList = finFastCodeRepo.findAllByFastCodeInAndStatus(finFastCodeList,status);
        Assert.notEmpty(finFastCodeDOList,"查不到快码");

        return finFastCodeDOList;
    }





}
