package com.elitesland.fin.repo.accountingengine;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.accountingengine.InvSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.InvSobAccountPeriodParam;
import com.elitesland.fin.domain.entity.accountingengine.QInvSobAccountPeriodDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class InvSobAccountPeriodRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QInvSobAccountPeriodDO qInvSobAccountPeriodDO = QInvSobAccountPeriodDO.invSobAccountPeriodDO;

    public List<InvSobAccountPeriodDTO> query(InvSobAccountPeriodParam finSobAccountPeriodParam) {

        Predicate where = whereEq(finSobAccountPeriodParam);
        JPAQuery<InvSobAccountPeriodDTO> query = select(InvSobAccountPeriodDTO.class).where(ExpressionUtils.allOf(where));

        return query.fetch();
    }


    public PagingVO<InvSobAccountPeriodDTO> page(InvSobAccountPeriodParam finSobAccountPeriodParam) {
        Predicate where = where(finSobAccountPeriodParam);
        JPAQuery<InvSobAccountPeriodDTO> query = select(InvSobAccountPeriodDTO.class).where(ExpressionUtils.allOf(where));

        finSobAccountPeriodParam.setPaging(query);
        finSobAccountPeriodParam.fillOrders(query, qInvSobAccountPeriodDO);

        List<InvSobAccountPeriodDTO> finAccountPeriodDTOList = query.fetch();

        return PagingVO.<InvSobAccountPeriodDTO>builder()
                .total(query.fetchCount())
                .records(finAccountPeriodDTOList)
                .build();
    }

    private Predicate where(InvSobAccountPeriodParam finSobAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSobAccountPeriodParam.getId() != null, qInvSobAccountPeriodDO.id, finSobAccountPeriodParam.getId())
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobCode()), qInvSobAccountPeriodDO.sobCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobName()), qInvSobAccountPeriodDO.sobName, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobName()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodCode()), qInvSobAccountPeriodDO.accountPeriodCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodName()), qInvSobAccountPeriodDO.accountPeriodName, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodName()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuCode()), qInvSobAccountPeriodDO.ouCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuName()), qInvSobAccountPeriodDO.ouName, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuName()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getPeriodStyle()), qInvSobAccountPeriodDO.periodStyle, StringUtil.buildLikeString(finSobAccountPeriodParam.getPeriodStyle()))
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getStatus()), qInvSobAccountPeriodDO.status, finSobAccountPeriodParam.getStatus())
                .build();
    }

    private Predicate whereEq(InvSobAccountPeriodParam finSobAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSobAccountPeriodParam.getId() != null, qInvSobAccountPeriodDO.id, finSobAccountPeriodParam.getId())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobCode()), qInvSobAccountPeriodDO.sobCode, finSobAccountPeriodParam.getSobCode())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodCode()), qInvSobAccountPeriodDO.accountPeriodCode, finSobAccountPeriodParam.getAccountPeriodCode())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuCode()), qInvSobAccountPeriodDO.ouCode, finSobAccountPeriodParam.getOuCode())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qInvSobAccountPeriodDO.id,
                qInvSobAccountPeriodDO.accountPeriodCode,
                qInvSobAccountPeriodDO.accountPeriodName,
                qInvSobAccountPeriodDO.status,
                qInvSobAccountPeriodDO.activeStartTime,
                qInvSobAccountPeriodDO.activeEndTime,
                qInvSobAccountPeriodDO.sobCode,
                qInvSobAccountPeriodDO.sobName,
                qInvSobAccountPeriodDO.ouCode,
                qInvSobAccountPeriodDO.ouName,
                qInvSobAccountPeriodDO.periodStyle,


                qInvSobAccountPeriodDO.createTime,
                qInvSobAccountPeriodDO.creator,
                qInvSobAccountPeriodDO.modifyTime,
                qInvSobAccountPeriodDO.updater
        )).from(qInvSobAccountPeriodDO);
    }
}
