package com.elitesland.fin.repo.creditaccount;

import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public interface CreditAccountRepo extends JpaRepository<CreditAccountDO, Long>, QuerydslPredicateExecutor<CreditAccountDO> {


    boolean existsByCreditAccountName(String creditAccountName);

    boolean existsByCreditAccountCode(String creditAccountCode);

    boolean existsByObjectCodeAndOuCode(String objectCode,String ouCode);

    boolean existsByObjectCode(String objectCode);

    CreditAccountDO findByObjectCodeAndOuCode(String objectCode,String ouCode);

    CreditAccountDO findByCreditAccountName(String creditAccountName);

    List<CreditAccountDO> findByObjectCodeInAndOuCode(List<String> objectCodeList,String ouCode);

    List<CreditAccountDO> findAllByCreditAccountCode(String accountCode);

    List<CreditAccountDO> findAllByObjectCode(String objectCode);

    @Transactional
    @Modifying
    @Query(value = "update credit_account set status = ?1 where id in ?2", nativeQuery = true)
    void updateStatusByIds(String status, List<Long> id);

    boolean existsByObjectCodeInAndOuCode(List<String> custCodes,String ouCode);
}
