package com.elitesland.fin.repo.creditaccount;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountRuleConfigDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountRuleConfigDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Slf4j
@Component
@AllArgsConstructor
public class CreditAccountRuleConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountRuleConfigDO jpaQDo = QCreditAccountRuleConfigDO.creditAccountRuleConfigDO;

    private final QCreditAccountRuleConfigDtlDO jpaDQDo = QCreditAccountRuleConfigDtlDO.creditAccountRuleConfigDtlDO;


    public void updateDynamically(CreditAccountRuleConfigDO param) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDo);
        //编码
        if (StringUtils.isNotBlank(param.getRuleCode())) {
            updateClause.set(jpaQDo.ruleCode, param.getRuleCode());
        }

        //名称
        if (StringUtils.isNotBlank(param.getRuleName())) {
            updateClause.set(jpaQDo.ruleName, param.getRuleName());
        }

        //适用单据
        if (StringUtils.isNotBlank(param.getOptDoc())) {
            updateClause.set(jpaQDo.optDoc, param.getOptDoc());
        }

        //启用状态
        if (StringUtils.isNotBlank(param.getStatus())) {
            updateClause.set(jpaQDo.status, param.getStatus());
        }

        updateClause.set(jpaQDo.modifyTime, LocalDateTime.now());
        updateClause.where(jpaQDo.id.eq(param.getId())).execute();
    }

    public PagingVO<CreditAccountRuleConfigPageVO> searchPage(CreditAccountRuleConfigQueryParam param) {
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        CreditAccountRuleConfigPageVO.class,
                        jpaDQDo.id,
                        jpaQDo.ruleCode,
                        jpaQDo.ruleName,
                        jpaQDo.optDoc,
                        jpaDQDo.optDocType,
                        jpaDQDo.optDocStatus,
                        jpaDQDo.calculatePercent,
                        jpaDQDo.maxLimit,
                        jpaDQDo.automaticReview,
                        jpaQDo.status,
                        jpaDQDo.masId,
                        jpaDQDo.ioCode,
                        jpaDQDo.ioName,
                        jpaDQDo.priorityNo,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion,
                        jpaDQDo.remark
                )
        ).from(jpaDQDo).leftJoin(jpaQDo).on(jpaQDo.id.eq(jpaDQDo.masId));
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<CreditAccountRuleConfigPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(CreditAccountRuleConfigQueryParam param) {
        Predicate predicate = jpaQDo.isNotNull();

        //账户编码/名称
        if (StringUtils.isNotBlank(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    jpaQDo.ruleCode.like("%" + param.getMultiKeywords() + "%"),
                    jpaQDo.ruleName.like("%" + param.getMultiKeywords() + "%")
            ));
        }

        //适用单据
        if (StringUtils.isNotEmpty(param.getOptDoc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.optDoc.eq(param.getOptDoc()));
        }

        //适用单据类型
        if (StringUtils.isNotEmpty(param.getOptDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optDocType.contains(param.getOptDocType()));
        }

        //适用单据状态
        if (StringUtils.isNotEmpty(param.getOptDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optDocStatus.eq(param.getOptDocStatus()));
        }

        //适用账户类型
        if (StringUtils.isNotEmpty(param.getOptAccountType())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optAccountType.eq(param.getOptAccountType()));
        }

        //指定账户
        if (StringUtils.isNotEmpty(param.getSpecificAccount())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.specificAccount.contains(param.getSpecificAccount())
                    .or(jpaDQDo.specificAccount.isNull()));
        }

        //启用状态
        if (StringUtils.isNotEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }

        return predicate;
    }

}