package com.elitesland.fin.rpc.order;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.param.SalReconciliatInvDTO;
import com.elitesland.order.param.SalReconciliatQueryDTO;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.order.service.SaleReconciliatRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@RequiredArgsConstructor
public class RmiOrderRpcServiceImpl implements RmiOrderRpcService {

//    private final TsSalSoRpcService tsSalSoRpcService;

    private final SaleReconciliatRpcService saleReconciliatRpcService;

    @Override
    public ApiResult<Long> orderAccountFlow() {

//        ApiResult<Long> apiResult=tsSalSoRpcService.orderAccountFlow(orderAccountFlowRpcParam);
//        Assert.notNull(apiResult,"返回订单流水信息失败");
//        Assert.isTrue(apiResult.isSuccess(),"返回订单流水信息失败");
//        return apiResult;
        return null;
    }

    @Override
    public List<SaleReconciliatDTO> querySalReconciliat(SalReconciliatQueryDTO salReconciliatQueryDTO) {

        ApiResult<List<SaleReconciliatDTO>> apiResult = saleReconciliatRpcService.querySalReconciliat(salReconciliatQueryDTO);
        Assert.notNull(apiResult, "查询对账单失败,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "查询对账单失败");
        return apiResult.getData();

    }

    @Override
    public Long updateTransState(SalReconciliatQueryDTO salReconciliatQueryDTO) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateTransState(salReconciliatQueryDTO);
        Assert.notNull(apiResult, "更新对账单明细传输状态失败,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新对账单明细传输状态失败");
        return apiResult.getData();

    }

    @Override
    public Long updateInvingState(List<SalReconciliatInvDTO> saleInvDTOList) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateInvingState(saleInvDTOList);
        Assert.notNull(apiResult, "更新开票状态为开票中,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新开票状态为开票中失败");
        return apiResult.getData();
    }


    @Override
    public Long updateInvedState(SaleReconciliatDTO saleInvDTO) {

        ApiResult<Long> apiResult = saleReconciliatRpcService.updateInvedState(saleInvDTO);
        Assert.notNull(apiResult, "更新开票状态为开票中,返回内容为空");
        Assert.isTrue(apiResult.isSuccess(), "更新开票状态为开票中失败");
        return apiResult.getData();
    }
}
