/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmountRoundConverter
implements Converter<BigDecimal> {
    private static final Logger log = LoggerFactory.getLogger(AmountRoundConverter.class);
    private final SystemRpcService systemRpcService;

    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public BigDecimal convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }

    public CellData convertToExcelData(BigDecimal value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        SysSettingVO amountDecimalPlace = this.systemRpcService.findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        log.info("find amount round strategy: {}", (Object)amountDecimalPlace);
        if (amountDecimalPlace == null) {
            return new CellData(value);
        }
        String settingVal = amountDecimalPlace.getSettingVal();
        if (settingVal == null || settingVal.equals("")) {
            return new CellData(value);
        }
        int accuracy = Integer.parseInt(settingVal);
        log.info("will convert {} to retain {} fraction", (Object)value, (Object)accuracy);
        return new CellData(NumberUtils.toScaledBigDecimal((BigDecimal)(value == null ? BigDecimal.ONE : value), (int)accuracy, (RoundingMode)RoundingMode.HALF_UP).toPlainString());
    }

    public AmountRoundConverter(SystemRpcService systemRpcService) {
        this.systemRpcService = systemRpcService;
    }
}

