package com.elitesland.fin.application.facade.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.math.NumberUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

@AllArgsConstructor
public class QuantityRoundConverter implements Converter<BigDecimal> {
    private final SystemRpcService systemRpcService;
    @Override
    public Class supportJavaTypeKey() {
        return null;
    }
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }
    @Override
    public BigDecimal convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
    @Override
    public CellData convertToExcelData(BigDecimal value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        SysSettingVO amountDecimalPlace = systemRpcService.findSysSettingByNo("QUANTITY_DECIMAL_PLACE");
        if (amountDecimalPlace == null) {
            return new CellData(value);
        }
        String settingVal = amountDecimalPlace.getSettingVal();
        if(settingVal == null || settingVal.equals("")) {
            return new CellData(value);
        }
        int accuracy = Integer.parseInt(settingVal);
        return new CellData(NumberUtils.toScaledBigDecimal(value == null ? BigDecimal.ONE : value, accuracy, RoundingMode.HALF_UP).toPlainString());
    }
}
