package com.elitesland.fin.application.facade.param.saleinv;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.saleinv
 * @date 2022/5/7 12:00
 */
@Data
public class SaleInvParam {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("来源系统单号")
    private String sourceSysNo;

    @ApiModelProperty("开票申请单号")
    private String applyNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("发票登记单号")
    private String invRegNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额(开票申请金额)")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("销售方发票抬头")
    private String saleInvTitle;

    @ApiModelProperty("销售税号")
    private String saleTaxNo;

    @ApiModelProperty("销售方电话")
    private String saleTel;

    @ApiModelProperty("销售详细地址")
    private String saleAdd;

    @ApiModelProperty("销售方开户行")
    private String saleBank;

    @ApiModelProperty("销售方银行账号")
    private String saleBankAcc;

    @ApiModelProperty("销售方备注")
    private String saleRemark;

    @ApiModelProperty("供应商ID")
    private Long saleId;

    @ApiModelProperty("供应商名称")
    private String saleName;

    @ApiModelProperty("供应商编码")
    private String saleCode;

    @ApiModelProperty("客户方发票抬头")
    private String custInvTitle;

    @ApiModelProperty("纳税人识别号")
    private String custTaxNo;

    @ApiModelProperty("客户地址")
    private String custAdd;

    @ApiModelProperty("客户电话")
    private String custTel;

    @ApiModelProperty("客户银行")
    private String custBank;

    @ApiModelProperty("客户银行账号")
    private String custBankAcc;

    @ApiModelProperty("客户备注")
    private String custRemark;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("开票人")
    private String invUser;

    @ApiModelProperty("收款人")
    private String recUser;

    @ApiModelProperty("复核人")
    private String revUser;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("推送方式")
    private String pushMethod;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("信息表编号")
    private String infoNo;

    @ApiModelProperty("快递编号")
    private String expressNo;

    @ApiModelProperty("开票状态")
    private String invState;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("相同商品合并开票：1是；0否")
    private String invMerge;

    private String creator;
    private LocalDateTime createTime;
    private String updater;
    private LocalDateTime modifyTime;
    private String remark;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("销售发票明细")
    List<SaleInvDtlParam> saleInvDtlParamList;

    @ApiModelProperty("开票客户名称")
    private String invCustName;

    @ApiModelProperty("开票客户编码")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    private Long invCustId;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;
}
