package com.elitesland.fin.application.facade.vo.apverconfig;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/7 9:21
 */
@Data
public class ApVerConfigVO implements Serializable {

    private static final long serialVersionUID = 2888390707565395978L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("方案编码")
    private String schemeNo;

    @ApiModelProperty("方案名称")
    private String schemeName;

    @ApiModelProperty("是否启用")
    private Boolean enableFlag;

    @ApiModelProperty("是否默认")
    private Boolean defaultFlag;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人名称")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("标记是否关联数据")
    private Boolean flag;

    @ApiModelProperty("明细信息")
    private List<ApVerConfigDtlVO> configDtlVOS;
}
