package com.elitesland.fin.application.facade.vo.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/13 13:11
 */
@Data
public class ArOrderDtlVO implements Serializable {

    private static final long serialVersionUID = -6375116976664134791L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("小类编码")
    private String smallCateCode;

    @ApiModelProperty("小类名称")
    private String smallCateName;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("费用部门编码")
    private String buCode;

    @ApiModelProperty("费用部门ID")
    private Long buId;

    @ApiModelProperty("费用部门")
    private String buName;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("发货单号")
    private String es11;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    private Long es12;

    @ApiModelProperty("订单客户")
    private String es13;

    @ApiModelProperty("客户编码(子客户)")
    private String es14;

    @ApiModelProperty("未税单价")
    private BigDecimal es15;

    @ApiModelProperty("税码")
    private String es16;

    @ApiModelProperty("发票号")
    private String es17;

    @ApiModelProperty("发票类型")
    private String es18;

    @ApiModelProperty("收款协议")
    private String es19;

    @ApiModelProperty("业务员编码")
    private String es20;

    @ApiModelProperty("币种")
    private String es21;

    @ApiModelProperty("汇率")
    private BigDecimal es22;

    @ApiModelProperty("起算日期")
    private LocalDateTime es23;

    @ApiModelProperty("到期付款日")
    private LocalDateTime es24;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;
}
