package com.elitesland.fin.application.facade.vo.invoice;

import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/05/25
 */
@Data
@ApiModel("开票申请详情")
public class InvoiceApplyRespVO extends SaleInvVO {

    @ApiModelProperty("开票明细行")
    List<InvoiceApplyDetailRespVO> details;

    @ApiModelProperty("开票明细汇总")
    List<InvoiceApplyDetailRespVO> summaryDetails;

    @JsonProperty
    public List<InvoiceApplyDetailRespVO> getSummaryDetails() {
        Map<String, List<InvoiceApplyDetailRespVO>> collect = details.stream().collect(Collectors.groupingBy(InvoiceApplyDetailRespVO::getItemCode));
        List<InvoiceApplyDetailRespVO> result = new ArrayList<>();
        collect.forEach((itemCode, details) -> {
            InvoiceApplyDetailRespVO row = details.get(0);
            InvoiceApplyDetailRespVO curr = new InvoiceApplyDetailRespVO();
            curr.setId(row.getId());
            curr.setInvNature(row.getInvNature());
            curr.setInvNatureName(row.getInvNatureName());
            curr.setItemId(row.getItemId());
            curr.setItemCode(row.getItemCode());
            curr.setItemName(row.getItemName());
            curr.setTaxCode(row.getTaxCode());
            curr.setTaxName(row.getTaxName());
            curr.setItemType(row.getItemType());
            curr.setUom(row.getUom());
            curr.setUomName(row.getUomName());
            curr.setQty(add(details, InvoiceApplyDetailRespVO::getQty));
            BigDecimal priceTotal = add(details, InvoiceApplyDetailRespVO::getPrice);
            curr.setPrice(priceTotal.divide(curr.getQty(), 2, RoundingMode.HALF_UP));
            curr.setTotalAmt(add(details, InvoiceApplyDetailRespVO::getTotalAmt));
            curr.setTaxRate(row.getTaxRate());
            curr.setTaxAmt(add(details, InvoiceApplyDetailRespVO::getTaxAmt));
            curr.setExclTaxAmt(add(details, InvoiceApplyDetailRespVO::getExclTaxAmt));
            result.add(curr);
        });
        return result;
    }

    private BigDecimal add(List<InvoiceApplyDetailRespVO> details, Function<InvoiceApplyDetailRespVO, BigDecimal> func) {
        return details.stream().map(func).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}
