package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
@Slf4j
public class FinFlexibleValueServiceImpl implements FinFlexibleValueService{

    private final FinFlexibleValueRepo finFlexibleValueRepo;

    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    @SysCodeProc
    @Override
    public PagingVO<FinFlexibleValueVO> page(FinFlexibleValueParam finFlexibleValueParam) {
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }
}
