package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ACCOUNT_FLOW_EXPORT;

@Service
@AllArgsConstructor
public class AccountFlowExportUsingParamServiceImpl implements DataExport<AccountFlowVO, AccountFlowPageParam> {
    private final AccountFlowService accountFlowService;
    @Override
    public String getTmplCode() {
        return FIN_ACCOUNT_FLOW_EXPORT;
    }
    @Override
    public PagingVO<AccountFlowVO> executeExport(AccountFlowPageParam queryParam) {
        return accountFlowService.page(queryParam);
    }
}
