package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ADJUST_EXPORT;

@Service
@AllArgsConstructor
public class AdjustExportUsingParamServiceImpl implements DataExport<AdjustOrderVO, AdjustOrderPageParam> {
    private final AdjustOrderService adjustOrderService;
    @Override
    public String getTmplCode() {
        return FIN_ADJUST_EXPORT;
    }
    
    @Override
    public PagingVO<AdjustOrderVO> executeExport(AdjustOrderPageParam adjustOrderPageParam) {
        return adjustOrderService.page(adjustOrderPageParam);
    }
}
