package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ADJUST_TO_EXPORT;

@Service
@AllArgsConstructor
public class AdjustToExportUsingParamServiceImpl implements DataExport<AdjustToOrderVO, AdjustToOrderParam> {
    private final AdjustToOrderService adjustToOrderService;
    @Override
    public String getTmplCode() {
        return FIN_ADJUST_TO_EXPORT;
    }
    
    @Override
    public PagingVO<AdjustToOrderVO> executeExport(AdjustToOrderParam adjustToOrderParam) {
        return adjustToOrderService.page(adjustToOrderParam);
    }
}
