package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.fin.application.service.excel.ExportConstants;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class DefaultAdjustExportServiceImpl implements DataExport<AdjustOrderVO, AdjustOrderPageParam> {
    private final AdjustOrderService adjustOrderService;
    @Override
    public String getTmplCode() {
        return ExportConstants.FIN_ADJUST_EXPORT_DEFAULT_IMPL;
    }
    
    @Override
    public PagingVO<AdjustOrderVO> executeExport(AdjustOrderPageParam param){
        return adjustOrderService.page(param);
    }
}
