package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.application.service.excel.ExportConstants;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class DefaultAdjustToExportServiceImpl implements DataExport<AdjustToOrderVO, AdjustToOrderParam> {
    private final AdjustToOrderService adjustToOrderService;
    @Override
    public String getTmplCode() {
        return ExportConstants.FIN_ADJUST_TO_EXPORT_DEFAULT_IMPL;
    }
    @Override
    public PagingVO<AdjustToOrderVO> executeExport(AdjustToOrderParam queryParam) {
        return adjustToOrderService.page(queryParam);
    }
}
