package com.elitesland.fin.application.web.recorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.recorder.RecOrderDtlService;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:09
 */
@RestController
@RequestMapping("/fin/recOrder")
@RequiredArgsConstructor
@Api(value = "收款单", tags = {"收款单"})
public class RecOrderController {

    private final RecOrderService recOrderService;
    private final RecOrderDtlService recOrderDtlService;
    private final RecOrderRpcTwoService recOrderRpcTwoService;

    @PostMapping("page")
    @ApiOperation("分页查询付款单")
    public ApiResult<PagingVO<RecOrderVO>> page(@RequestBody RecOrderPageParam param) {
        return ApiResult.ok(recOrderService.page(param));
    }

    @PostMapping("pageDtl")
    @ApiOperation("分页查询收款单明细")
    public ApiResult<PagingVO<RecOrderDtlVO>> pageDtl(@RequestBody RecOrderDtlPageParam param) {
        return ApiResult.ok(recOrderDtlService.page(param));
    }

    @GetMapping("/query/{id}")
    @ApiOperation("查询收款单款单详细信息(无明细信息)")
    public ApiResult<RecOrderVO> queryById(@PathVariable("id") Long id) {
        return ApiResult.ok(recOrderService.queryById(id));
    }

    @GetMapping("/queryDetails/{id}")
    @ApiOperation("查询收款单详细信息(明细集合)")
    public ApiResult<RecOrderVO> queryDetails(@PathVariable("id") Long id) {
        return ApiResult.ok(recOrderService.queryDetailsById(id));
    }

    @DeleteMapping("delete")
    @ApiOperation("删除收款单")
    public ApiResult<List<Long>> delete(@RequestBody List<Long> ids) {
        return recOrderService.deleteByIds(ids);
    }

    @GetMapping("defaultValue")
    @ApiOperation("获取新增默认值")
    public ApiResult<RecOrderVO> defaultValue() {
        return recOrderService.defaultValue();
    }


    @PostMapping("save")
    @ApiOperation("新增/修改-保存付款单")
    public ApiResult<Long> save(@RequestBody RecOrderSaveParam param) {
        return recOrderService.save(param);
    }

    @PostMapping("submit")
    @ApiOperation("新增/修改-提交付款单")
    public ApiResult<Long> submit(@RequestBody RecOrderSaveParam param) {
        return recOrderService.submit(param);
    }

    @ApiOperation("【工作流相关】提交流程")
    @GlobalTransactional
    @GetMapping(value = "/submit/{id}")
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        recOrderRpcTwoService.submit(id);
        return ApiResult.ok();
    }
}
