package com.elitesland.fin.domain.param.recorder;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:31
 */
@Data
public class RecOrderPageParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 5812683739447232229L;
    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty("销售公司ID")
    private Long ouId;
    @ApiModelProperty("销售公司ID集合")
    private List<Long> ouIdList;
    @ApiModelProperty("销售业务员名称")
    private String saleUser;
    @ApiModelProperty("销售业务员名称集合")
    private List<String> saleUserList;
    @ApiModelProperty("销售业务员ID集合")
    private List<Long> saleUserIdList;
    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;
    @ApiModelProperty("收款单类型ID集合")
    private List<Long> recTypeIdList;
    @ApiModelProperty("收款单号")
    private String recOrderNo;
    @ApiModelProperty("收款单号集合")
    private List<String> recOrderNoList;
    @ApiModelProperty("币种编码")
    private String currCode;
    @ApiModelProperty("币种编码集合")
    private List<String> currCodeList;
    @ApiModelProperty("含税总金额从")
    private BigDecimal totalAmtFrom;

    @ApiModelProperty("含税总金额至")
    private BigDecimal totalAmtTo;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间从")
    private LocalDateTime auditDateStart;

    @ApiModelProperty("审核时间至")
    private LocalDateTime auditDateEnd;

    @ApiModelProperty("单据状态")
    private String orderState;
    @ApiModelProperty("单据状态集合")
    private List<String> orderStateList;
    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("收款日期从")
    private LocalDateTime reDateStart;

    @ApiModelProperty("收款日期至")
    private LocalDateTime reDateEnd;

    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;
    @ApiModelProperty("核销状态集合")
    private List<String> verStateList;
    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户ID集合")
    private List<Long> custIdList;
    @ApiModelProperty("客户名称")
    private String custName;
    @ApiModelProperty("客户名称集合")
    private List<String> custNameList;
    @ApiModelProperty("销售部门ID")
    private Long buId;
    @ApiModelProperty("销售部门I集合D")
    private List<Long> buIdList;
    @ApiModelProperty("收款公司ID")
    private Long recOuId;
    @ApiModelProperty("收款公司ID集合")
    private List<Long> recOuIdList;
    @ApiModelProperty("销售组织ID")
    private Long orgId;
    @ApiModelProperty("销售组织ID集合")
    private List<Long> orgIdList;

}
