/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.account;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountRuleConfigConvert;
import com.elitesland.fin.application.facade.dto.account.AccountRuleConfigDTO;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigQueryVO;
import com.elitesland.fin.domain.service.account.AccountRuleConfigDomainService;
import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import com.elitesland.fin.repo.account.AccountRuleConfigRepoProc;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class AccountRuleConfigDomainServiceImpl
implements AccountRuleConfigDomainService {
    private final AccountRuleConfigRepo accountRuleConfigRepo;
    private final AccountRuleConfigRepoProc accountRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<AccountRuleConfigDO> findById(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        return this.accountRuleConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.accountRuleConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(AccountRuleConfigDO invSceneConfigDO) {
        this.accountRuleConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<AccountRuleConfigPageVO> searchPage(AccountRuleConfigQueryParam param) {
        return this.accountRuleConfigRepoProc.searchPage(param);
    }

    @Override
    public List<AccountRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode) {
        List<AccountRuleConfigDO> sceneConfigDOS = this.accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        return sceneConfigDOS.stream().map(AccountRuleConfigConvert.INSTANCE::do2VO).collect(Collectors.toList());
    }

    @Override
    public AccountRuleConfigDTO findByRuleCode(String ruleCode) {
        List<AccountRuleConfigDO> sceneConfigDOS = this.accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return AccountRuleConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        }
        return null;
    }

    public AccountRuleConfigDomainServiceImpl(AccountRuleConfigRepo accountRuleConfigRepo, AccountRuleConfigRepoProc accountRuleConfigRepoProc) {
        this.accountRuleConfigRepo = accountRuleConfigRepo;
        this.accountRuleConfigRepoProc = accountRuleConfigRepoProc;
    }
}

