package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.rpc.system.SystemRpcService;
import org.apache.commons.lang3.math.NumberUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class QuantityRoundConverter implements Converter<BigDecimal, String> {
    private static final SystemRpcService systemRpcService = SpringContextHolder.getBean(SystemRpcService.class);
    
    @Override
    public String convert(BigDecimal value) {
        if(value == null) {
            value = BigDecimal.ZERO;
        }
        SysSettingVO amountDecimalPlace = systemRpcService.findSysSettingByNo("QUANTITY_DECIMAL_PLACE");
        if (amountDecimalPlace == null) {
            return value.toString();
        }
        String settingVal = amountDecimalPlace.getSettingVal();
        if(settingVal == null || settingVal.equals("")) {
            return value.toPlainString();
        }
        int accuracy = Integer.parseInt(settingVal);
        return NumberUtils.toScaledBigDecimal(value, accuracy, RoundingMode.HALF_UP).toPlainString();
    }
}
