package com.elitesland.fin.application.facade.param.creditaccount;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 账户表;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "信用账户查询参数")
public class CreditAccountParam {


    private List<Long> ids;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("对象类型(客户组 客户)")
    private String objectType;

    @ApiModelProperty("信用账户编码/名称")
    private String creditAccountCodeName;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;

    @ApiModelProperty("对象编码")
    private String objectCode;

    private Set<String> creditAccountCodes;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("信用账户占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("信用账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("信用账户可用额度")
    private BigDecimal creditAccountAvailableLimit;

    @ApiModelProperty("信用账户类型")
    private String creditAccountType;

    @ApiModelProperty("状态")
    private String status;

}