package com.elitesland.fin.application.service.arverrec;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitesland.fin.application.convert.arverrec.ArVerRecDtlConvert;
import com.elitesland.fin.application.facade.param.arverrec.ArVerRecSaveParam;
import com.elitesland.fin.application.facade.vo.arverrec.ArVerRecDtlVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtl;
import com.elitesland.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.arverrec.ArVerRecDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.fin.infr.factory.arverrec.ArVerRecFactory;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/26 16:14
 */
@Service
@RequiredArgsConstructor
public class ArVerRecServiceImpl implements ArVerRecService{

    private final ArVerRecFactory arVerRecFactory;
    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    private final ArVerRecDomainService arVerRecDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ArVerRecDtlVO> page(ArVerRecPageParam pageParam) {
        PagingVO<ArVerRecDtlDTO> page = arVerRecFactory.page(pageParam);
        return ArVerRecDtlConvert.INSTANCE.convertPage(page);

    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void confirm(ArVerRecSaveParam param) {
        ArVerConfigDTO arVerConfigDTO = arVerConfigDomainService.queryById(param.getConfigId());
        if(arVerConfigDTO==null || !arVerConfigDTO.getEnableFlag()){
            throw new BusinessException("该方案[应收核销方案ID"+param.getConfigId()+"]不存在或已停用");
        }
        List<ArVerConfigDtlDTO> configDtlDTOList = arVerConfigDTO.getArVerConfigDtlDTOS().stream().filter(ArVerConfigDtlDTO::getMatchFlag).collect(Collectors.toList());

        Map<String, ?> conditions = configDtlDTOList.stream().collect(Collectors.toMap(ArVerConfigDtlDTO::getFieldNo,t->{
            if(t.getFieldType().equals(FinConstant.STRING)){
                return String.class;
            } else if(t.getFieldType().equals(FinConstant.BIGDECIMAL)){
                return BigDecimal.class;
            } else if(t.getFieldType().equals(FinConstant.LOCALDATETIME)){
                return LocalDateTime.class;
            } else if(t.getFieldType().equals(FinConstant.LONG)){
                return Long.class;
            }
            return String.class;
        }));
        //设置核销方案数据
        param.getParams().forEach(s->{
            s.setSchemeId(arVerConfigDTO.getId());
            s.setSchemeName(arVerConfigDTO.getSchemeName());
            s.setSchemeNo(arVerConfigDTO.getSchemeNo());
            s.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_MANU.getValueCode());
        });
        List<ArVerRecDtl> arVerRecDtls = ArVerRecDtlConvert.INSTANCE.convertList(param.getParams());

        Map<String, List<ArVerRecDtl>> listMap = arVerRecDtls.stream().collect(Collectors.groupingBy(t -> groupByCond(t, conditions)));
        for (Map.Entry<String, List<ArVerRecDtl>> entry : listMap.entrySet()){
            arVerRecDomainService.save(entry.getValue());
        }
        arVerRecDtls.forEach(t->{
            if(t.getOrderType().equals(FinConstant.AR)){
                arOrderDomainService.updateVerAmt(t.getOrderId(),t.getAmt());
            }else if (t.getOrderType().equals(FinConstant.REC)){
                recOrderDomainService.updateVerAmt(t.getOrderId(),t.getAmt());
            }
        });
    }

    @Override
    public void cancel(List<Long> ids) {
        if(CollUtil.isEmpty(ids)){
            throw new BusinessException("传入参数不能为空");
        }
        Set<Long> masIds = new HashSet<>(ids);
        List<ArVerRecDtlDTO> recDtlDTOS = arVerRecDomainService.queryDtlByMasIds(masIds);
        if(CollUtil.isEmpty(recDtlDTOS)){
            throw new BusinessException("应收核销明细查询为空");
        }
        List<Long> dtlIds = recDtlDTOS.stream().map(ArVerRecDtlDTO::getId).collect(Collectors.toList());
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long rows = arVerRecDomainService.logicDelByIds(masIds,user.getUsername(),user.getId());
        Long dtlRows = arVerRecDomainService.logicDelDtlByIds(dtlIds);
        if(rows.intValue()!=masIds.size() || dtlRows.intValue()!= dtlIds.size()){
            throw new BusinessException("取消应收核销失败");
        }
        Map<Long, List<ArVerRecDtlDTO>> recDtlDTOMap = recDtlDTOS.stream().collect(Collectors.groupingBy(ArVerRecDtlDTO::getOrderId));
        for (Map.Entry<Long, List<ArVerRecDtlDTO>> entry : recDtlDTOMap.entrySet()){
            String orderType = entry.getValue().get(0).getOrderType();
            BigDecimal amt = entry.getValue().stream().map(ArVerRecDtlDTO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            if(orderType.equals(FinConstant.AR)){
                arOrderDomainService.updateVerAmt(entry.getKey(),amt);
            }else if (orderType.equals(FinConstant.REC)){
                recOrderDomainService.updateVerAmt(entry.getKey(),amt);
            }
        }
    }

    private String groupByCond(Object object, Map<String,?> conditions) {
        StringBuilder key=new StringBuilder();
        for (Map.Entry<String,?> cond : conditions.entrySet()){
            Object fieldValue = ReflectUtil.getFieldValue(object, cond.getKey());
            if (cond.getValue().equals(LocalDateTime.class)){
                key.append(((LocalDateTime) fieldValue).toLocalDate().toString()).append("&");
            }else {
                key.append(fieldValue.toString()).append("&");
            }
        }
        return key.toString();
    }
}
