package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DefaultDateTimeConverter;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class InitialLimitExportEntity implements Serializable {
    @ApiModelProperty("公司编码")
    private String ouCode;
    
    @ApiModelProperty("公司ID")
    private Long ouId;
    
    @ApiModelProperty("公司名称")
    private String ouName;
    
    @ApiModelProperty("对象类型(客户组 客户)")
    private String objectTypeName;
    
    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;
    
    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;
    
    @ApiModelProperty("信用账户名称")
    private String creditAccountName;
    
    @ApiModelProperty("信用账户类型")
    private String creditAccountTypeName;
    
    @ApiModelProperty("对象编码")
    private String objectCode;
    
    @ApiModelProperty("部门ID")
    private Long deptId;
    
    @ApiModelProperty("部门编码")
    private String deptCode;
    
    @ApiModelProperty("部门名称")
    private String deptName;
    
    @ApiModelProperty("产品线编码")
    private String productLineCode;
    
    @ApiModelProperty("产品线名称")
    private String productLineName;
    
    @ApiModelProperty("业务员编号")
    private String salesmanNo;
    
    @ApiModelProperty("业务员姓名")
    private String salesmanName;
    
    @ApiModelProperty("信用账户额度")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String creditAccountLimit;
    
    @ApiModelProperty("信用账户占用额度")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String creditAccountOccupancyLimit;
    
    @ApiModelProperty("信用账户使用额度")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String creditAccountUsedLimit;
    
    @ApiModelProperty("状态")
    private String statusName;
    
    @ApiModelProperty("信用账户可用额度")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String creditAccountAvailableLimit;
    
    @ApiModelProperty("初始化结束时间")
    @ExcelConvert(converter = DefaultDateTimeConverter.class)
    private String finishedTime;
    
    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    
    private String creator;
}
