package com.elitesland.fin.application.service.excel.exp;



import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.excel.entity.AccountFlowExportEntity;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class DefaultAccountFlowExportServiceImpl implements DataExport<AccountFlowExportEntity, AccountFlowPageParam> {
    private final AccountFlowService accountFlowService;

    @Override
    public String getTmplCode() {
        return "fin_account_flow_export";
    }

    @Override
    public PagingVO<AccountFlowExportEntity> execute(AccountFlowPageParam queryParam, int page, int pageSize) {

        PagingVO<AccountFlowVO> accountFlowVOPagingVO = accountFlowService.page(queryParam);

        return PagingVO.<AccountFlowExportEntity>builder()
                .total(accountFlowVOPagingVO.getTotal())
                .records(ExcelConvertUtils.convert(accountFlowVOPagingVO.getRecords(), AccountFlowExportEntity.class))
                .build();
    }
}
