package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountInitialLimitService;
import com.elitesland.fin.application.service.excel.entity.InitialLimitExportEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ACCOUNT_INIT_EXPORT_DEFAULT_IMPL;

@Service
@AllArgsConstructor
public class DefaultCreditAccountInitialLimitExportServiceImpl implements DataExport<InitialLimitExportEntity, CreditAccountInitialLimitParam> {
   private final CreditAccountInitialLimitService creditAccountInitialLimitService;
    @Override
    public String getTmplCode() {
        return FIN_ACCOUNT_INIT_EXPORT_DEFAULT_IMPL;
    }
    @Override
    public PagingVO<InitialLimitExportEntity> executeExport(CreditAccountInitialLimitParam queryParam) {
        PagingVO<InitialLimitPageVO> page = creditAccountInitialLimitService.pageSearch(queryParam);
        return new PagingVO<>(
                    page.getTotal(),
                    ExcelConvertUtils.convert(page.getRecords(), InitialLimitExportEntity.class)
                );
    }
}
