package com.elitesland.fin.application.web.apverconfig;

import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigVO;
import com.elitesland.fin.application.facade.vo.apverconfig.PayAndApOrderVO;
import com.elitesland.fin.application.service.apverconfig.ApVerConfigService;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.domain.param.apverconfig.OrderParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/2 14:26
 */
@RestController
@RequestMapping("/fin/apVerConfig")
@RequiredArgsConstructor
@Api(value = "应付核销管理方案", tags = {"应付核销管理方案"})
public class ApVerConfigController {

    private final ApVerConfigService apverConfigService;

    @PostMapping("order")
    @ApiOperation("根据查询条件查询付款单和应付单信息")
    public ApiResult<PayAndApOrderVO> queryOrderByParam(@RequestBody OrderParam param) {
        return ApiResult.ok(apverConfigService.queryOrderByParam(param));
    }

    @PostMapping("save")
    @ApiOperation("新增/修改核销方案")
    public ApiResult<String> save(@RequestBody ApVerConfigSaveParam param) {
        return apverConfigService.save(param);
    }

    @GetMapping("queryDetails/{id}")
    @ApiOperation("查看详情")
    public ApiResult<ApVerConfigVO> queryDetail(@PathVariable("id") Long id) {
        return apverConfigService.queryById(id);
    }

    @GetMapping("queryDtl")
    @ApiOperation("获取配置字段")
    public ApiResult<List<ApVerConfigDtlVO>> queryDetail() {
        return apverConfigService.queryDtl();
    }

    @GetMapping("queryAll")
    @ApiOperation("获取已启用的核销方案下拉框")
    public ApiResult<List<ApVerConfigVO>> queryAll() {
        return apverConfigService.queryAllConfig();
    }

    @PostMapping("pageConfig")
    @ApiOperation("分页查询核销方案列表")
    public ApiResult<PagingVO<ApVerConfigVO>> pageConfig(@RequestBody ApVerConfigPageParam param) {
        return apverConfigService.page(param);
    }

    @PutMapping("stop")
    @ApiOperation("停用核销方案")
    public ApiResult<List<Long>> stop(@RequestBody List<Long> ids) {
        return apverConfigService.stop(ids);
    }

    @PutMapping("updateDef/{id}")
    @ApiOperation("设置默认")
    public ApiResult<Long> updateDef(@PathVariable("id") Long id) {
        return apverConfigService.updateDef(id);
    }

    @GetMapping("getDef")
    @ApiOperation("获取核销方案默认")
    public ApiResult<ApVerConfigVO> getDef() {
        return apverConfigService.getDef();
    }
}
