package com.elitesland.fin.application.web.workflow;

import com.elitescloud.boot.wrapper.Isolatable;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.common.CallBackPathConstant;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;


@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(CallBackPathConstant.FIN_REC_ORDER_PATH)
public class FinRecOrderController implements WorkflowCallBack {

    private final Isolatable isolatable;
//    private final ApOrderProcessService apOrderProcessService;
//    private final ArOrderProcessService arOrderProcessService;
    private final RecOrderProcessService recOrderProcessService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人:{}", payload.toString());
        try {
            return (WorkflowResult<ArrayList<String>>)isolatable.apply(()->{
                ArrayList<String> resultList = new ArrayList<>();
                if (StringUtils.isNotEmpty(payload.getCustomParams())) {
                    resultList = recOrderProcessService.taskAssignee(payload.getBusinessKey(),
                            payload.getCustomParams());
                }
                return WorkflowResult.success(resultList);
            },payload.getTenantId());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("状态修改回调:{}",payload.toString());
        recOrderProcessService.processStatusChange(Long.parseLong(payload.getBusinessKey()), payload.getProcInstStatus(),
                payload.getCommentInfo());
        return WorkflowResult.success(null);
    }
}
